// Get the database module. Notice that we are never disconnecting
const { connectToDatabase } = require("./db");
const PORT = 3000;

// Get the Express object
const express = require("express");
const app = express();

// Set up Pug as the view engine
app.set("view engine", "pug"); 

// Middleware to parse HTML form data into req.body
app.use(express.urlencoded({ extended: true })); // true allows nested objects

// Tell Express where the styles and views are
app.use('/styles', express.static("styles"));

// Main function that starts the server
async function main() {
    const db = await connectToDatabase();
    const products = db.collection("products");

    // Mount products router
    app.use("/products", require("./routes/products")(products));

    // Home redirects to list products
    app.get("/", (req, res) => res.redirect("/products"));

    // Start server
    app.listen(PORT);
    console.log(`Server is listening at http://localhost:${PORT}`);
}

main();